//=============================================================================
// PersistentBalloon.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc 常に表示されるバルーンを実装
 * @help
 * 移動ルートのスクリプトから常時バルーンを表示
 *
 * 使用方法:
 * this.startPersistentBalloon(バルーンID);
 * this.stopPersistentBalloon();
 *
 * 例:
 * this.startPersistentBalloon(1);  // バルーンID 1 を常時表示
 * this.stopPersistentBalloon();    // バルーン表示を停止
 */

(function() {
    const _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
    Game_CharacterBase.prototype.initMembers = function() {
        _Game_CharacterBase_initMembers.call(this);
        this._persistentBalloonId = 0;
        this._persistentBalloonActive = false;
    };

    const _Game_CharacterBase_update = Game_CharacterBase.prototype.update;
    Game_CharacterBase.prototype.update = function() {
        _Game_CharacterBase_update.call(this);
        if (this._persistentBalloonActive) {
            if (this._balloonId === 0 && !this.isBalloonPlaying()) {
                this.requestBalloon(this._persistentBalloonId);
            }
        }
    };

    Game_CharacterBase.prototype.startPersistentBalloon = function(balloonId) {
        this._persistentBalloonId = balloonId;
        this._persistentBalloonActive = true;
        this.requestBalloon(balloonId);
    };

    Game_CharacterBase.prototype.stopPersistentBalloon = function() {
        this._persistentBalloonId = 0;
        this._persistentBalloonActive = false;
        this._balloonId = 0;
    };
})();
